<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function department()
	{
		return $this->hasOne('Department', 'department_id');
	}

	public function role()
	{
		return $this->hasOne('Role', 'role_id');
	}

	public function employee()
	{
		return $this->hasOne('Employee', 'user_id');
	}

}