<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->uuid('id');
			$table->uuid('user_id');
			$table->string('recipient_name');
			$table->uuid('area_id');
			$table->string('recipient_email');
			$table->string('delivery_speed');
			$table->string('payment_term');
			$table->integer('status')->default('0');
			$table->string('order_number', 10)->unique();
			$table->uuid('merchant_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}