<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCityTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('city_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('city_id')->unsigned();
			$table->string('name', 255);
			$table->string('slug', 255)->nullable();
			$table->string('locale', 255)->index();
		});
	}

	public function down()
	{
		Schema::drop('city_translations');
	}
}