<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInterviewsTable extends Migration {

	public function up()
	{
		Schema::create('interviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('mobile');
			$table->string('email');
			$table->string('status')->default('hold');
		});
	}

	public function down()
	{
		Schema::drop('interviews');
	}
}