<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 255);
			$table->string('image', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->string('birth_date', 255)->nullable();
			$table->string('social_status', 255)->nullable();
			$table->string('child_number', 255)->nullable();
			$table->string('degree', 255)->nullable();
			$table->string('graduation_date', 255)->nullable();
			$table->string('military_status', 255)->nullable();
			$table->string('whatsapp', 255)->nullable();
			$table->string('user_type', 255);
			$table->longText('notes')->nullable();
			$table->string('reset_code', 255)->nullable();
			$table->string('verified_code', 255)->nullable();
			$table->integer('added_by_id')->unsigned()->nullable();
			$table->tinyInteger('report_general')->default('0');
			$table->tinyInteger('report_private')->default('0');
			$table->timestamp('last_login_at')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->string('remember_token', 100)->nullable();
			$table->integer('role_id')->nullable();
			$table->integer('branch_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('code', 255)->nullable();
			$table->string('fingerprint_number', 255)->nullable();
			$table->date('hiring_date')->nullable();
			$table->string('contact_email', 255)->nullable();
			$table->string('contact_phone', 255)->nullable();
			$table->string('contact_whatsapp', 255)->nullable();
			$table->integer('university_id')->nullable();
			$table->integer('college_id')->nullable();
			$table->integer('last_salary_id')->nullable();
			$table->float('salary')->nullable();
			$table->date('ended_date')->nullable();
			$table->longText('pass')->nullable();
			$table->tinyInteger('is_team_leader')->default('0');
			$table->double('rate')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}