<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('visit_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->longText('reason');
			$table->longText('report');
			$table->integer('visit_id')->unsigned();
			$table->string('locale')->index();
		});
	}

	public function down()
	{
		Schema::drop('visit_translations');
	}
}