<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('set null');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('universities', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('universities', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('country_translations', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('city_translations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('branch_translations', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('category_translations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('university_translations', function(Blueprint $table) {
			$table->foreign('university_id')->references('id')->on('universities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('colleges', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('colleges', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('colleges', function(Blueprint $table) {
			$table->foreign('university_id')->references('id')->on('universities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('college_translations', function(Blueprint $table) {
			$table->foreign('college_id')->references('id')->on('colleges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('colors', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('color_translations', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visit_translations', function(Blueprint $table) {
			$table->foreign('visit_id')->references('id')->on('visits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_months', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_months', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('promotion_translations', function(Blueprint $table) {
			$table->foreign('promotion_id')->references('id')->on('promotions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rate_factors', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rate_factors', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rate_factor_translations', function(Blueprint $table) {
			$table->foreign('rate_factor_id')->references('id')->on('rate_factors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('rate_factor_id')->references('id')->on('rate_factors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_vacations', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_vacations', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_vacations', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interview_translations', function(Blueprint $table) {
			$table->foreign('interview_id')->references('id')->on('interviews')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interview_mettings', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interview_mettings', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interview_mettings', function(Blueprint $table) {
			$table->foreign('interview_id')->references('id')->on('interviews')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('interview_metting_translations', function(Blueprint $table) {
			$table->foreign('interview_metting_id')->references('id')->on('interview_mettings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questionnaires', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questionnaires', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questionnaires', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questionnaire_translations', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('questionnaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_requests', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_requests', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_requests', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emp_request_translations', function(Blueprint $table) {
			$table->foreign('emp_request_id')->references('id')->on('emp_requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('discount_translations', function(Blueprint $table) {
			$table->foreign('discount_id')->references('id')->on('discounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reward_translations', function(Blueprint $table) {
			$table->foreign('reward_id')->references('id')->on('rewards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacation_translations', function(Blueprint $table) {
			$table->foreign('vacation_id')->references('id')->on('vacations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacation_settings', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacation_settings', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacation_setting_translations', function(Blueprint $table) {
			$table->foreign('vacation_setting_id')->references('id')->on('vacation_settings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainees', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainees', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainees', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainee_report_translations', function(Blueprint $table) {
			$table->foreign('trainee_report_id')->references('id')->on('trainee_reports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainee_translations', function(Blueprint $table) {
			$table->foreign('trainee_id')->references('id')->on('trainees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainee_reports', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainee_reports', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainee_reports', function(Blueprint $table) {
			$table->foreign('trainee_id')->references('id')->on('trainees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applicant_translations', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('password_requests', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_settings', function(Blueprint $table) {
			$table->foreign('added_by_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_settings', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_setting_translations', function(Blueprint $table) {
			$table->foreign('email_setting_id')->references('id')->on('email_settings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('messages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('from_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('to_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('message_files', function(Blueprint $table) {
			$table->foreign('message_id')->references('id')->on('messages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_added_by_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_branch_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_added_by_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_branch_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_category_id_foreign');
		});
		Schema::table('universities', function(Blueprint $table) {
			$table->dropForeign('universities_added_by_id_foreign');
		});
		Schema::table('universities', function(Blueprint $table) {
			$table->dropForeign('universities_branch_id_foreign');
		});
		Schema::table('country_translations', function(Blueprint $table) {
			$table->dropForeign('country_translations_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('city_translations', function(Blueprint $table) {
			$table->dropForeign('city_translations_city_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_country_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_city_id_foreign');
		});
		Schema::table('branch_translations', function(Blueprint $table) {
			$table->dropForeign('branch_translations_branch_id_foreign');
		});
		Schema::table('category_translations', function(Blueprint $table) {
			$table->dropForeign('category_translations_category_id_foreign');
		});
		Schema::table('university_translations', function(Blueprint $table) {
			$table->dropForeign('university_translations_university_id_foreign');
		});
		Schema::table('colleges', function(Blueprint $table) {
			$table->dropForeign('colleges_added_by_id_foreign');
		});
		Schema::table('colleges', function(Blueprint $table) {
			$table->dropForeign('colleges_branch_id_foreign');
		});
		Schema::table('colleges', function(Blueprint $table) {
			$table->dropForeign('colleges_university_id_foreign');
		});
		Schema::table('college_translations', function(Blueprint $table) {
			$table->dropForeign('college_translations_college_id_foreign');
		});
		Schema::table('colors', function(Blueprint $table) {
			$table->dropForeign('colors_added_by_id_foreign');
		});
		Schema::table('color_translations', function(Blueprint $table) {
			$table->dropForeign('color_translations_color_id_foreign');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->dropForeign('visits_added_by_id_foreign');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->dropForeign('visits_branch_id_foreign');
		});
		Schema::table('visit_translations', function(Blueprint $table) {
			$table->dropForeign('visit_translations_visit_id_foreign');
		});
		Schema::table('employee_months', function(Blueprint $table) {
			$table->dropForeign('employee_months_employee_id_foreign');
		});
		Schema::table('employee_months', function(Blueprint $table) {
			$table->dropForeign('employee_months_branch_id_foreign');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->dropForeign('promotions_added_by_id_foreign');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->dropForeign('promotions_user_id_foreign');
		});
		Schema::table('promotion_translations', function(Blueprint $table) {
			$table->dropForeign('promotion_translations_promotion_id_foreign');
		});
		Schema::table('rate_factors', function(Blueprint $table) {
			$table->dropForeign('rate_factors_added_by_id_foreign');
		});
		Schema::table('rate_factors', function(Blueprint $table) {
			$table->dropForeign('rate_factors_color_id_foreign');
		});
		Schema::table('rate_factor_translations', function(Blueprint $table) {
			$table->dropForeign('rate_factor_translations_rate_factor_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_added_by_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_employee_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_rate_factor_id_foreign');
		});
		Schema::table('emp_vacations', function(Blueprint $table) {
			$table->dropForeign('emp_vacations_added_by_id_foreign');
		});
		Schema::table('emp_vacations', function(Blueprint $table) {
			$table->dropForeign('emp_vacations_employee_id_foreign');
		});
		Schema::table('emp_vacations', function(Blueprint $table) {
			$table->dropForeign('emp_vacations_branch_id_foreign');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->dropForeign('interviews_added_by_id_foreign');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->dropForeign('interviews_branch_id_foreign');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->dropForeign('interviews_country_id_foreign');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->dropForeign('interviews_city_id_foreign');
		});
		Schema::table('interviews', function(Blueprint $table) {
			$table->dropForeign('interviews_category_id_foreign');
		});
		Schema::table('interview_translations', function(Blueprint $table) {
			$table->dropForeign('interview_translations_interview_id_foreign');
		});
		Schema::table('interview_mettings', function(Blueprint $table) {
			$table->dropForeign('interview_mettings_added_by_id_foreign');
		});
		Schema::table('interview_mettings', function(Blueprint $table) {
			$table->dropForeign('interview_mettings_branch_id_foreign');
		});
		Schema::table('interview_mettings', function(Blueprint $table) {
			$table->dropForeign('interview_mettings_interview_id_foreign');
		});
		Schema::table('interview_metting_translations', function(Blueprint $table) {
			$table->dropForeign('interview_metting_translations_interview_metting_id_foreign');
		});
		Schema::table('questionnaires', function(Blueprint $table) {
			$table->dropForeign('questionnaires_added_by_id_foreign');
		});
		Schema::table('questionnaires', function(Blueprint $table) {
			$table->dropForeign('questionnaires_employee_id_foreign');
		});
		Schema::table('questionnaires', function(Blueprint $table) {
			$table->dropForeign('questionnaires_branch_id_foreign');
		});
		Schema::table('questionnaire_translations', function(Blueprint $table) {
			$table->dropForeign('questionnaire_translations_questionnaire_id_foreign');
		});
		Schema::table('emp_requests', function(Blueprint $table) {
			$table->dropForeign('emp_requests_added_by_id_foreign');
		});
		Schema::table('emp_requests', function(Blueprint $table) {
			$table->dropForeign('emp_requests_employee_id_foreign');
		});
		Schema::table('emp_requests', function(Blueprint $table) {
			$table->dropForeign('emp_requests_branch_id_foreign');
		});
		Schema::table('emp_request_translations', function(Blueprint $table) {
			$table->dropForeign('emp_request_translations_emp_request_id_foreign');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->dropForeign('discounts_added_by_id_foreign');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->dropForeign('discounts_employee_id_foreign');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->dropForeign('discounts_branch_id_foreign');
		});
		Schema::table('discount_translations', function(Blueprint $table) {
			$table->dropForeign('discount_translations_discount_id_foreign');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->dropForeign('rewards_added_by_id_foreign');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->dropForeign('rewards_employee_id_foreign');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->dropForeign('rewards_branch_id_foreign');
		});
		Schema::table('reward_translations', function(Blueprint $table) {
			$table->dropForeign('reward_translations_reward_id_foreign');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->dropForeign('vacations_added_by_id_foreign');
		});
		Schema::table('vacations', function(Blueprint $table) {
			$table->dropForeign('vacations_branch_id_foreign');
		});
		Schema::table('vacation_translations', function(Blueprint $table) {
			$table->dropForeign('vacation_translations_vacation_id_foreign');
		});
		Schema::table('vacation_settings', function(Blueprint $table) {
			$table->dropForeign('vacation_settings_added_by_id_foreign');
		});
		Schema::table('vacation_settings', function(Blueprint $table) {
			$table->dropForeign('vacation_settings_branch_id_foreign');
		});
		Schema::table('vacation_setting_translations', function(Blueprint $table) {
			$table->dropForeign('vacation_setting_translations_vacation_setting_id_foreign');
		});
		Schema::table('trainees', function(Blueprint $table) {
			$table->dropForeign('trainees_added_by_id_foreign');
		});
		Schema::table('trainees', function(Blueprint $table) {
			$table->dropForeign('trainees_branch_id_foreign');
		});
		Schema::table('trainees', function(Blueprint $table) {
			$table->dropForeign('trainees_category_id_foreign');
		});
		Schema::table('trainee_report_translations', function(Blueprint $table) {
			$table->dropForeign('trainee_report_translations_trainee_report_id_foreign');
		});
		Schema::table('trainee_translations', function(Blueprint $table) {
			$table->dropForeign('trainee_translations_trainee_id_foreign');
		});
		Schema::table('trainee_reports', function(Blueprint $table) {
			$table->dropForeign('trainee_reports_added_by_id_foreign');
		});
		Schema::table('trainee_reports', function(Blueprint $table) {
			$table->dropForeign('trainee_reports_branch_id_foreign');
		});
		Schema::table('trainee_reports', function(Blueprint $table) {
			$table->dropForeign('trainee_reports_trainee_id_foreign');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->dropForeign('applicants_category_id_foreign');
		});
		Schema::table('applicant_translations', function(Blueprint $table) {
			$table->dropForeign('applicant_translations_applicant_id_foreign');
		});
		Schema::table('password_requests', function(Blueprint $table) {
			$table->dropForeign('password_requests_employee_id_foreign');
		});
		Schema::table('email_settings', function(Blueprint $table) {
			$table->dropForeign('email_settings_added_by_id_foreign');
		});
		Schema::table('email_settings', function(Blueprint $table) {
			$table->dropForeign('email_settings_branch_id_foreign');
		});
		Schema::table('email_setting_translations', function(Blueprint $table) {
			$table->dropForeign('email_setting_translations_email_setting_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_branch_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_parent_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_from_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_to_id_foreign');
		});
		Schema::table('message_files', function(Blueprint $table) {
			$table->dropForeign('message_files_message_id_foreign');
		});
	}
}