<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;
    protected $fillable = array('name', 'country_id', 'state_id', 'lon', 'lat');
    protected $visible = array('name', 'country_id', 'state_id', 'lon', 'lat');

    public function state()
    {
        return $this->belongsTo('State');
    }

    public function address()
    {
        return $this->belongsTo('Address');
    }

    public function zones()
    {
        return $this->hasMany('Zone', 'zone_id');
    }

}