<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;
    protected $fillable = array('name', 'lat', 'lon');
    protected $visible = array('name', 'lat', 'lon');

    public function states()
    {
        return $this->hasMany('State');
    }

    public function address()
    {
        return $this->belongsTo('Address');
    }

}