<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class State extends Model 
{

    protected $table = 'states';
    public $timestamps = true;
    protected $fillable = array('name', 'country_id', 'lon');
    protected $visible = array('name', 'country_id', 'lon');

    public function cities()
    {
        return $this->hasMany('City');
    }

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function address()
    {
        return $this->belongsTo('Address');
    }

}