<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttendancesTable extends Migration {

	public function up()
	{
		Schema::create('attendances', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('student_id')->unsigned()->nullable();
			$table->bigInteger('event_id')->unsigned()->nullable();
			$table->bigInteger('event_realization_id')->unsigned();
			$table->bigInteger('challenge_id')->unsigned();
			$table->bigInteger('quiz_id')->unsigned();
			$table->bigInteger('activity_id')->unsigned();
			$table->integer('credits');
			$table->integer('s1');
			$table->integer('s2');
			$table->integer('s3');
			$table->integer('s4');
			$table->integer('s5');
			$table->integer('s6');
			$table->integer('s7');
			$table->string('s8');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('notified')->default(FALSE);
			$table->enum('state', array('registered', 'waiting', 'done', 'invited', 'canceled'));
			$table->integer('max_credits')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('attendances');
	}
}