<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255)->nullable()->index();
			$table->text('description')->nullable();
			$table->enum('quad', array('0', '1', '2', '3'))->index();
			$table->boolean('done')->index()->default(false);
			$table->datetime('done_at')->nullable()->index();
			$table->bigInteger('user_id')->unsigned();
			$table->integer('next_id')->nullable()->index();
			$table->bigInteger('project_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}