<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarketingInnerTable extends Migration {

	public function up()
	{
		Schema::create('marketing_inner', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_id')->unsigned()->nullable();
			$table->integer('marketing_id')->unsigned()->nullable();
			$table->double('commission')->nullable();
			$table->enum('status', array('pending', 'accepted', 'refused'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('marketing_inner');
	}
}