<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarketingMainsTable extends Migration {

	public function up()
	{
		Schema::create('marketing_mains', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100)->nullable();
			$table->integer('marketing_category_id')->unsigned()->nullable();
			$table->bigInteger('budget_amount')->nullable();
			$table->integer('marketing_type_id')->unsigned()->nullable();
			$table->date('from_date')->nullable();
			$table->date('to_date')->nullable();
			$table->enum('status', array('pending', 'progress', 'done'))->nullable();
			$table->integer('result_customers')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('marketing_mains');
	}
}