<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('user_role_id')->unsigned();
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->timestamp('email_verified_at');
			$table->rememberToken('rememberToken');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}