<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 64)->unique();
			$table->string('email', 255)->unique();
			$table->string('email_pending', 255);
			$table->string('email_hash', 32);
			$table->string('first_name', 64);
			$table->string('last_name', 64);
			$table->string('password', 64);
			$table->string('otp_secret', 128);
			$table->string('salt', 128);
			$table->string('last_ip', 32);
			$table->datetime('last_login');
			$table->tinyInteger('verified');
			$table->tinyInteger('disabled');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}