<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('authors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('geo_region', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('geo_country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('geo_city', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('geo_country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_subscriptions', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_author_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_user_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_book_id_foreign');
		});
		Schema::table('geo_region', function(Blueprint $table) {
			$table->dropForeign('geo_region_country_id_foreign');
		});
		Schema::table('geo_city', function(Blueprint $table) {
			$table->dropForeign('geo_city_country_id_foreign');
		});
		Schema::table('book_subscriptions', function(Blueprint $table) {
			$table->dropForeign('book_subscriptions_book_id_foreign');
		});
		Schema::table('book_subscriptions', function(Blueprint $table) {
			$table->dropForeign('book_subscriptions_user_id_foreign');
		});
	}
}