<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionTable extends Migration {

	public function up()
	{
		Schema::create('transaction', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('in', 'out'));
			$table->string('service_type', 191)->nullable();
			$table->integer('user_id')->unsigned();
			$table->string('amount', 191);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transaction');
	}
}