<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tripe_id')->unsigned();
			$table->string('customer_name');
			$table->string('customer_email');
			$table->integer('numberofpeople');
			$table->timestamps();
			$table->enum('status', array('confirmed', 'cancelled'));
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}