<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code')->unique();
			$table->float('discount_percentage')->nullable();
			$table->integer('number_of_use')->default('0');
			$table->integer('user_used_code_count')->default('0');
			$table->boolean('is_active')->default(false);
			$table->boolean('use_as_ad')->default(false);
			$table->enum('coupon_type', array('percentage', 'product'));
			$table->decimal('coupon_price', 15,5)->nullable();
			$table->date('expire_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}