<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePharmaciesTable extends Migration {

	public function up()
	{
		Schema::create('pharmacies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 1000);
			$table->string('slug', 1000)->unique()->nullable();
			$table->string('address', 1000)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('pincode', 255)->nullable();
			$table->string('country', 255)->nullable();
			$table->string('code', 1000);
			$table->enum('status', array('1', '0'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pharmacies');
	}
}