<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiplomasTable extends Migration {

	public function up()
	{
		Schema::create('diplomas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->tinyInteger('type')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('title_ar');
			$table->string('title_en');
			$table->string('description_ar');
			$table->string('description_en');
			$table->string('terms_ar');
			$table->string('terms_en');
			$table->string('certificates_ar');
			$table->string('certificates_en');
			$table->string('duration_houres');
			$table->string('duration_days');
			$table->time('start_at');
			$table->string('education_time_ar');
			$table->string('education_time_en');
			$table->string('place');
			$table->string('price');
			$table->string('discount')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('diplomas');
	}
}