<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotesLogTable extends Migration {

	public function up()
	{
		Schema::create('notes_log', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('note_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->enum('status', array('opened', 'qualified', 'unqualified', 'resolved', 'resolve_accepted', 'resolve_reject', 'resolve_confirmed', 'closed_with_notes', 'closed'));
			$table->timestamp('due_date');
		});
	}

	public function down()
	{
		Schema::drop('notes_log');
	}
}