<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('types', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('priority_id')->references('id')->on('priorities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('direction_id')->references('id')->on('directions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('note_id')->references('id')->on('notes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resolved_notes', function(Blueprint $table) {
			$table->foreign('note_id')->references('id')->on('notes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resolved_notes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('resolved_notes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resolved_attachments', function(Blueprint $table) {
			$table->foreign('resolved_note_id')->references('id')->on('resolved_notes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resolved_attachments', function(Blueprint $table) {
			$table->foreign('attachment_type_id')->references('id')->on('attachment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('recommendation_attachments', function(Blueprint $table) {
			$table->foreign('attachment_type_id')->references('id')->on('attachment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('recommendation_attachments', function(Blueprint $table) {
			$table->foreign('recommendation_id')->references('id')->on('recommendations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes_log', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes_log', function(Blueprint $table) {
			$table->foreign('note_id')->references('id')->on('notes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('login_logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('weeks', function(Blueprint $table) {
			$table->foreign('month_id')->references('id')->on('months')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('types', function(Blueprint $table) {
			$table->dropForeign('types_category_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_user_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_area_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_type_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_priority_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_direction_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_note_id_foreign');
		});
		Schema::table('resolved_notes', function(Blueprint $table) {
			$table->dropForeign('resolved_notes_note_id_foreign');
		});
		Schema::table('resolved_notes', function(Blueprint $table) {
			$table->dropForeign('resolved_notes_user_id_foreign');
		});
		Schema::table('resolved_attachments', function(Blueprint $table) {
			$table->dropForeign('resolved_attachments_resolved_note_id_foreign');
		});
		Schema::table('resolved_attachments', function(Blueprint $table) {
			$table->dropForeign('resolved_attachments_attachment_type_id_foreign');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->dropForeign('recommendations_user_id_foreign');
		});
		Schema::table('recommendation_attachments', function(Blueprint $table) {
			$table->dropForeign('recommendation_attachments_attachment_type_id_foreign');
		});
		Schema::table('recommendation_attachments', function(Blueprint $table) {
			$table->dropForeign('recommendation_attachments_recommendation_id_foreign');
		});
		Schema::table('notes_log', function(Blueprint $table) {
			$table->dropForeign('notes_log_user_id_foreign');
		});
		Schema::table('notes_log', function(Blueprint $table) {
			$table->dropForeign('notes_log_note_id_foreign');
		});
		Schema::table('login_logs', function(Blueprint $table) {
			$table->dropForeign('login_logs_user_id_foreign');
		});
		Schema::table('weeks', function(Blueprint $table) {
			$table->dropForeign('weeks_month_id_foreign');
		});
	}
}