<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->string('profile_id', 120)->unique();
			$table->string('user_sponserid', 120);
			$table->string('user_sponsername', 100);
			$table->string('name', 60);
			$table->string('email', 255)->unique();
			$table->string('password', 120);
			$table->string('phone', 15)->unique();
			$table->enum('status', array('Active', 'Blocked'));
			$table->tinyInteger('pay_status')->default('0');
			$table->string('payment_proof', 120);
			$table->enum('current_plan', array('Basic', 'Premium'));
			$table->datetime('approved_date')->nullable();
			$table->bigInteger('approved_by')->unsigned()->nullable()->index();
			$table->string('token', 64)->nullable();
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}