<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserBasicInfoTable extends Migration {

	public function up()
	{
		Schema::create('user_basic_info', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('user_id');
			$table->string('address')->nullable();
			$table->string('city', 60)->nullable();
			$table->string('state', 60)->nullable();
			$table->string('country', 60)->nullable();
			$table->string('whatsapp', 14)->nullable();
			$table->string('pancard', 50)->nullable();
			$table->date('dob')->nullable();
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_basic_info');
	}
}