<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->enum('type', array(''text'', ''url'', ''email'', ''number'', ''map'', ''long_text'', ''file'', ''radio''));
			$table->longText('value');
			$table->string('module');
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}