<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestTable extends Migration {

	public function up()
	{
		Schema::create('request', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->datetime('started_at');
			$table->datetime('ended_at')->nullable();
			$table->integer('service_id')->unsigned();
			$table->string('request_info', 300);
			$table->enum('state', array('solved', 'asigned', 'assigned'));
			$table->string('answer_to', 30)->nullable();
			$table->integer('engineer_id')->unsigned()->nullable();
			$table->boolean('seen_by_client');
			$table->integer('rating')->nullable();
			$table->integer('request_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('request');
	}
}