<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Conversation extends Eloquent {

	protected $table = 'conversations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function bot()
	{
		return $this->belongsTo('Model\Bot');
	}

	public function intent()
	{
		return $this->belongsTo('Model\Intent');
	}

}