<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepartmentsTable extends Migration {

	public function up()
	{
		Schema::create('departments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('parent_id')->unsigned();
			$table->string('name_ar', 255)->index();
			$table->string('name_en');
			$table->longText('description_ar');
			$table->longText('description_en');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('departments');
	}
}