<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseChaptersTable extends Migration {

	public function up()
	{
		Schema::create('course_chapters', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned()->index();
			$table->bigInteger('chapter_id')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('course_chapters');
	}
}