<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('main_section_id')->unsigned()->index();
			$table->bigInteger('sub_section_id')->unsigned();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->string('name', 255)->unique();
			$table->boolean('video_hosting');
			$table->string('intro_video_url', 255)->nullable();
			$table->string('intro_video_file', 255)->nullable();
			$table->longText('description');
			$table->longText('requirements')->nullable();
			$table->boolean('type');
			$table->string('content_type', 255)->nullable();
			$table->boolean('language');
			$table->longText('location')->nullable();
			$table->boolean('is_free');
			$table->double('price')->nullable();
			$table->double('discount_price')->nullable();
			$table->integer('level');
			$table->string('duration', 255)->nullable();
			$table->string('keywords', 255)->nullable();
			$table->longText('meta_description')->nullable();
			$table->integer('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}