<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_details', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->index();
			$table->integer('id_number')->index();
			$table->boolean('gender');
			$table->longText('qualifications');
			$table->integer('age');
			$table->longText('description');
			$table->boolean('status');
			$table->integer('employee_number');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_details');
	}
}