<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCooperativeTrainingsTable extends Migration {

	public function up()
	{
		Schema::create('cooperative_trainings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('department_id')->unsigned()->nullable()->index();
			$table->integer('available_seats')->nullable();
			$table->timestamp('date_sent')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cooperative_trainings');
	}
}