<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNominationsTable extends Migration {

	public function up()
	{
		Schema::create('nominations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned()->index();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->bigInteger('department_id')->unsigned()->nullable()->index();
			$table->integer('status')->nullable();
			$table->timestamp('date_sent')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('nominations');
	}
}