<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('p_script', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('p_project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('p_script', function(Blueprint $table) {
			$table->foreign('database_id')->references('database_id')->on('p_database')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('p_project', function(Blueprint $table) {
			$table->foreign('database_id')->references('database_id')->on('p_database')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('p_database', function(Blueprint $table) {
			$table->foreign('project_id')->references('project_id')->on('p_project')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('p_log', function(Blueprint $table) {
			$table->foreign('script_id')->references('script_id')->on('p_script')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('p_script', function(Blueprint $table) {
			$table->dropForeign('p_script_project_id_foreign');
		});
		Schema::table('p_script', function(Blueprint $table) {
			$table->dropForeign('p_script_database_id_foreign');
		});
		Schema::table('p_project', function(Blueprint $table) {
			$table->dropForeign('p_project_database_id_foreign');
		});
		Schema::table('p_database', function(Blueprint $table) {
			$table->dropForeign('p_database_project_id_foreign');
		});
		Schema::table('p_log', function(Blueprint $table) {
			$table->dropForeign('p_log_script_id_foreign');
		});
	}
}