<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomFeaturesTable extends Migration {

	public function up()
	{
		Schema::create('room_features', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->json('name');
			$table->string('img');
			$table->integer('order_column')->nullable();
			$table->boolean('online')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('room_features');
	}
}