<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoriesTable extends Migration {

	public function up()
	{
		Schema::create('inventories', function(Blueprint $table) {
			$table->increments('id');
			$table->mediumInteger('union_id');
			$table->string('order_id', 15);
			$table->mediumInteger('product_id');
			$table->enum('type', array('in', 'out'));
			$table->float('quantity');
			$table->mediumInteger('created_by');
			$table->string('created_by_ip', 15);
			$table->mediumInteger('updated_by')->nullable();
			$table->string('updated_by_ip', 15)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('inventories');
	}
}