<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkshopesAndTutorsTable extends Migration {

	public function up()
	{
		Schema::create('workshopes_and_tutors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->longText('name');
			$table->tinyInteger('type');
			$table->longText('description')->nullable();
			$table->integer('city_id');
			$table->smallInteger('country_id');
			$table->string('latitude', 255)->nullable();
			$table->string('longitude', 255)->nullable();
			$table->date('date_from')->nullable();
			$table->bigInteger('user_id');
			$table->tinyInteger('status')->default('0');
			$table->date('date_to')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('workshopes_and_tutors');
	}
}