<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SalarySheet extends Eloquent {

	protected $table = 'salary_sheet';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('employee_id', 'monthly_days', 'working_days', 'total_sales', 'per_day', 'basic_salary', 'commission', 'previous_due', 'tips', 'incentive', 'housing', 'transport', 'medical', 'bonus', 'mobile', 'food', 'travelling', 'gross_salary', 'housing_d', 'transport_d', 'mobile_d', 'loan', 'absent', 'advance', 'sick_leave', 'penalty', 'total_deductions', 'net_salary', 'paid_salary', 'relay', 'paid_way', 'paid_date', 'branch', 'month', 'year', 'mall_id');

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

}