<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('category_id');
			$table->string('title', 256);
			$table->text('description');
			$table->string('price', 128);
			$table->enum('status', array('active', 'inactive'));
			$table->enum('product_type', array('new', 'used'));
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->timestamp('deleted_at');
			$table->string('slug', 256);
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}