<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type', 128);
			$table->string('first_name', 128);
			$table->string('last_name', 128);
			$table->string('username', 128);
			$table->string('email', 128);
			$table->string('password', 128);
			$table->timestamp('created_at');
			$table->timestamp('updated_at')->nullable();
			$table->timestamp('deleted_at')->nullable();
			$table->enum('email_validated', array('yes', 'no'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}