<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('ref_number', 150);
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('provider_id')->unsigned()->nullable();
			$table->integer('category_id')->unsigned()->nullable();
			$table->integer('subcategory_id')->unsigned()->nullable();
			$table->integer('type');
			$table->text('description');
			$table->integer('pay_type');
			$table->double('price', 8,2);
			$table->double('added_value', 8,2);
			$table->double('admin_commission', 8,2);
			$table->double('admin_commission_ratio', 8,2);
			$table->double('total_price', 8,2);
			$table->date('start_date');
			$table->time('start_time');
			$table->datetime('full_start_date');
			$table->date('end_date');
			$table->time('end_time');
			$table->datetime('full_end_date');
			$table->integer('duration');
			$table->integer('status')->default('0');
			$table->integer('pay_status')->default('0');
			$table->text('cancel_reason');
			$table->integer('plan_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}