<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('provider_id')->unsigned()->nullable();
			$table->string('name', 150);
			$table->double('price', 8,2);
			$table->integer('duration');
			$table->text('description');
			$table->text('properties');
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}