<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('userable');
			$table->string('reviewable');
			$table->integer('order_id')->unsigned()->nullable();
			$table->enum('type', array(''));
			$table->double('rate', 255);
			$table->text('comment');
			$table->boolean('showOrhide');
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}