<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('provider_id')->unsigned()->nullable();
			$table->integer('order_id')->unsigned()->nullable();
			$table->double('amount', 8,2);
			$table->double('deposit', 8,2)->default('0.0');
			$table->integer('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}