<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('number', 50);
			$table->integer('provider_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('status')->default('0');
			$table->integer('pay_staus')->default('0');
			$table->integer('pay_type');
			$table->integer('city_id')->unsigned()->nullable();
			$table->double('lat', 8,2);
			$table->double('lng', 8,2);
			$table->text('map_desc');
			$table->date('date');
			$table->time('time');
			$table->text('notes');
			$table->string('record', 150);
			$table->string('invoice', 100);
			$table->double('offer_amount', 8,2);
			$table->double('deposit', 8,2);
			$table->double('price', 8,2);
			$table->double('vat', 8,2);
			$table->double('admin_commission', 8,2);
			$table->decimal('admin_commission_ratio', 8,2);
			$table->double('final_total', 8,2);
			$table->integer('provider_type_id')->unsigned()->nullable();
			$table->text('cancel_reason');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}