<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->string('phone', 50);
			$table->string('country_code', 10);
			$table->string('email', 100);
			$table->string('password', 50);
			$table->string('code', 10);
			$table->double('wallet', 8,2);
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('region_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('image', 50)->default('default.png');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}