<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MedicalExamination extends Model 
{

    protected $table = 'medical_examinations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('comment_and_description', 'doctor_description', 'doctor_recommandation', 'booking_id');

    public function booking()
    {
        return $this->belongsTo('Booking');
    }

}