<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Booking extends Eloquent {

	protected $table = 'bookings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('doctor_id', 'patient_id', 'content', 'type', 'clinic_id', 'date', 'time', 'patient_name', 'longitude', 'latitude', 'location', 'status', 'booking_type_id', 'softDeletes', 'shift_id', 'is_review', 'next_review', 'review_date');

	public function shift()
	{
		return $this->belongsTo('Shift');
	}

	public function prescriptions()
	{
		return $this->hasMany('Prescription');
	}

	public function medicalExaminations()
	{
		return $this->hasMany('MedicalExamination');
	}

	public function medicalAnalysises()
	{
		return $this->hasMany('MedicalAnalysis');
	}

	public function medicalXRays()
	{
		return $this->hasMany('MedicalXRay');
	}

	public function images()
	{
		return $this->hasMany('BookingImage');
	}

}